"use client"
import { Terminal } from "lucide-react"
import { SiteHeader } from "@/components/site-header"
import { useEffect, useState } from "react"

export default function Home() {
  const [terminalLines, setTerminalLines] = useState<string[]>([])

  useEffect(() => {
    const messages = ["> All Systems Operational", "> ", "> Contact Us Via discord.gg/fuze or fuzestudios@proton.me"]

    let index = 0
    const interval = setInterval(() => {
      if (index < messages.length) {
        setTerminalLines((prev) => [...prev, messages[index]])
        index++
      } else {
        clearInterval(interval)
      }
    }, 800)

    return () => clearInterval(interval)
  }, [])

  return (
    <div className="min-h-screen bg-background text-foreground relative overflow-x-hidden">
      <div className="absolute inset-0 overflow-hidden pointer-events-none">
        <img
          src="/la-city-bg.jpg"
          alt=""
          className="w-full h-full object-cover"
          style={{ imageRendering: "high-quality" }}
        />
        <div className="absolute inset-0 bg-black/50"></div>
      </div>

      <SiteHeader />

      <main className="container mx-auto px-6 py-20 md:py-32 relative">
        <div className="max-w-4xl mx-auto space-y-12">
          {/* Left content */}
          <div className="space-y-8 relative z-10">
            <div className="space-y-6">
              <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-[#b7ff00]/10 border border-[#b7ff00]/20 backdrop-blur-sm">
                <div className="w-2 h-2 bg-[#b7ff00] rounded-full animate-pulse"></div>
                <p className="text-sm font-medium uppercase tracking-wider" style={{ color: "#b7ff00" }}>
                  System Online
                </p>
              </div>

              <h1 className="text-6xl md:text-7xl lg:text-8xl font-black leading-none text-balance italic">
                <span className="block text-foreground">Fuze</span>
                <span className="block bg-gradient-to-r from-[#b7ff00] via-[#9ee600] to-[#b7ff00] bg-clip-text text-transparent animate-gradient bg-[length:200%_auto]">
                  Studios
                </span>
              </h1>

              <div className="h-1 w-24 bg-gradient-to-r from-[#b7ff00] to-transparent rounded-full"></div>
            </div>

            <div className="space-y-4">
              <p className="text-lg md:text-xl leading-relaxed max-w-2xl font-medium text-white">
                Innovative, high-performance FiveM resources since 2018. Trusted by thousands for unparalleled quality
                and reliability.
              </p>
            </div>

            {/* Live Terminal */}
            <div className="bg-secondary/30 backdrop-blur-sm border-0 rounded-lg overflow-hidden">
              <div className="bg-secondary/50 border-b border-muted/20 px-4 py-3 flex items-center gap-3">
                <Terminal className="h-4 w-4 text-white" />
                <span className="text-sm font-mono text-white">system.terminal</span>
                <div className="ml-auto flex gap-2">
                  <div className="w-3 h-3 rounded-full bg-red-500/50"></div>
                  <div className="w-3 h-3 rounded-full" style={{ background: "rgba(183, 255, 0, 0.5)" }}></div>
                  <div className="w-3 h-3 rounded-full bg-green-500/50"></div>
                </div>
              </div>
              <div className="p-4 space-y-2 font-mono text-sm h-64 overflow-hidden">
                {terminalLines.map((line, index) => (
                  <div key={index} className="text-white animate-in fade-in duration-300">
                    {line}
                    {index === terminalLines.length - 1 && (
                      <span className="inline-block w-2 h-4 bg-white ml-1 animate-pulse"></span>
                    )}
                  </div>
                ))}
              </div>
            </div>
          </div>
        </div>
      </main>
    </div>
  )
}
